<div>
    <div class="field">
        @if ($label)
            <label for="file-{{ $id }}" class="label">{{ $label }}</label>
        @endif
        <div class="file is-info is-fullwidth has-name {{ $box ? 'is-boxed' : '' }}" id="file-{{ $id }}">
            <label class="file-label">
                @php
                    $attr = $attributes->merge([
                        'id' => $id,
                        'class' => 'file-input',
                        'name' => $name,
                        'accept' => $accept,
                    ]);
                    if ($attributes->has('disabled') && !$attributes->get('disabled')) {
                        $attr = $attr->except(['disabled']);
                    }
                @endphp
                <input type="file" {!! $attr !!}>
                <span class="file-cta">
                    <span class="file-icon">
                        <span class="material-symbols-outlined is-size-6">
                            upload_file
                        </span>
                    </span>
                    <span class="file-label">
                        {{ $placeholder }}...
                    </span>
                </span>
                <span class="file-name">{{ $filename ?? '' }}</span>
            </label>
        </div>
    </div>
    @if (isset($hint))
        <p class="help is-info">{{ $hint }}</p>
    @endif
    @error($name)
        <p class="help is-danger">{{ $message }}</p>
    @enderror
    <script type="module">
        $(document).ready(function() {
            $('#{{ $id }}').on('change', function(event) {
                if (this.files.length > 0) {
                    $('.file-name', $(this).closest('div.field')).html(this.files[0].name)
                } else {
                    $('.file-name', $(this).closest('div.field')).empty()
                }
            })
        });
    </script>
</div>
