<?php

namespace V360\FormComponents\View\Components;

use Illuminate\Support\Str;
use Illuminate\View\Component;

class Checkbox extends Component
{

  public string $name;
  public $options;
  public $value;
  public ?string $label = null;
  public $margin;
  public ?string $hint = null;

  public ?string $id = null;
  public string $class;
  public bool $multiple;

  /**
   * Create a new component instance
   *
   * @param string $name
   * @param array $options
   * @param mixed $value
   * @param mixed $label
   * @param string|null $classes
   * @param bool $margin
   * @param string|null $hint
   */
  public function __construct(
    string $name,
    $options = [],
    $value = null,
    $label = null,
    ?string $classes = null,
    bool $margin = true,
    ?string $hint = null
  ) {
    $this->name = $name;
    $this->class = "is-checkradio " . $classes;
    $this->label = $label ? $label : ($label === false ? false : Str::title(str_replace('_', ' ', $name)));

    if ($options && count($options) > 0) {
      $this->multiple = true;
      $this->name = $this->name . "[]";
      //prepare options
      $checkOptions = [];
      foreach ($options as $val => $label) {
        //is_checked
        $checked = is_array($value) && in_array($val, $value);
        $checkOptions[] = [
          'id' => Str::uuid(),
          'value' => $val,
          'label' => $label,
          'checked' => $checked,
        ];
      }
      $this->options = $checkOptions;
      $this->margin = '';
    } else {
      $this->multiple = false;
      $this->value = $value;
      $this->id = Str::uuid();
      $this->options = [];
      $this->margin = $margin ? 'pt-5 mt-2' : '';
    }

    $this->hint = $hint;
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vform::components.checkbox');
  }
}
