<div id="input-table-{{ $id }}">
    <div class="level">
        <div class="level-left">
            <div class="level-item">
                <p class="subtitle has-text-weight-bold has-text-info">{{ $label }}</p>
            </div>
        </div>
        <div class="level-right">
            <div class="level-item">
                <button type="button" class="button is-outlined is-danger" id="clear">
                    <span class="icon">
                        <span class="material-symbols-outlined is-size-6">
                            close
                        </span>
                    </span>
                    <span>Clear</span>
                </button>
            </div>
            <div class="level-item">
                <button type="button" class="button is-outlined is-info" id="add">
                    <span class="icon">
                        <span class="material-symbols-outlined is-size-6">
                            add
                        </span>
                    </span>
                    <span>Add</span>
                </button>
            </div>
        </div>
    </div>
    <div class="table-container">
        <table class="table is-fullwidth">
            <thead>
                <tr>
                    @if ($fields)
                        @foreach ($fields as $i => $field)
                            @if ($widths)
                                <th style="width: {{ $widths[$i] }}%;">{{ $field['label'] }}</th>
                            @else
                                <th>{{ $field['label'] }}</th>
                            @endif
                        @endforeach
                    @endif
                    <th>
                        <span class="icon">
                            <span class="material-symbols-outlined">
                                list
                            </span>
                        </span>
                    </th>
                </tr>
            </thead>
            <tbody id="input-rows">
                @if ($sample)
                    <tr class="default-row">
                        @if ($fields)
                            @foreach ($fields as $field)
                                <td>
                                    @switch($field['type'])
                                        @case('number')
                                            <div class="field">
                                                <p class="control has-icons-left">
                                                    <input type="number" class="input is-small has-text-right"
                                                        name="{{ $name }}[{{ $field['name'] }}][]"
                                                        placeholder="{{ $field['placeholder'] }}" {{ $field['value'] }}
                                                        step="{{ $field['step'] }}" {{ $field['min'] }} {{ $field['max'] }}
                                                        {{ $field['required'] }} {{ $field['pattern'] }}
                                                        title="{{ $field['placeholder'] }}">
                                                    <span class="icon is-small is-left">
                                                        <span class="material-symbols-outlined">
                                                            123
                                                        </span>
                                                    </span>
                                                </p>
                                            </div>
                                        @break

                                        @default
                                            <div class="field">
                                                <p class="control has-icons-left">
                                                    <input type="text" class="input is-small"
                                                        name="{{ $name }}[{{ $field['name'] }}][]"
                                                        placeholder="{{ $field['placeholder'] }}"
                                                        {{ $field['required'] ?? '' }} {{ $field['pattern'] }}
                                                        title="{{ $field['placeholder'] }}">
                                                    <span class="icon is-small is-left">
                                                        <span class="material-symbols-outlined is-size-6">
                                                            text_fields
                                                        </span>
                                                    </span>
                                                </p>
                                            </div>
                                    @endswitch
                                </td>
                            @endforeach
                        @endif
                        <td class="action">
                            <button type="button" class="button is-ghost has-text-danger remove is-small">
                                <span class="icon">
                                    <span class="material-symbols-outlined is-size-6">
                                        delete
                                    </span>
                                </span>
                            </button>
                        </td>
                    </tr>
                @endif
            </tbody>
            <tfoot class="is-hidden">
                <tr class="input-row">
                    @foreach ($fields as $field)
                        <td>
                            @switch($field['type'])
                                @case('number')
                                    <div class="field">
                                        <p class="control has-icons-left">
                                            <input type="number" class="input is-small has-text-right"
                                                name="{{ $name }}[{{ $field['name'] }}][]"
                                                placeholder="{{ $field['placeholder'] }}" {{ $field['value'] }}
                                                step="{{ $field['step'] }}" {{ $field['min'] }} {{ $field['max'] }}
                                                {{ $field['required'] }} {{ $field['pattern'] }}
                                                title="{{ $field['placeholder'] }}" disabled>
                                            <span class="icon is-small is-left">
                                                <span class="material-symbols-outlined">
                                                    123
                                                </span>
                                            </span>
                                        </p>
                                    </div>
                                @break

                                @default
                                    <div class="field">
                                        <p class="control has-icons-left">
                                            <input type="text" class="input is-small"
                                                name="{{ $name }}[{{ $field['name'] }}][]"
                                                placeholder="{{ $field['placeholder'] }}" {{ $field['required'] ?? '' }}
                                                {{ $field['pattern'] }} title="{{ $field['placeholder'] }}" disabled>
                                            <span class="icon is-small is-left">
                                                <span class="material-symbols-outlined is-size-6">
                                                    text_fields
                                                </span>
                                            </span>
                                        </p>
                                    </div>
                            @endswitch
                        </td>
                    @endforeach
                    <td class="action">
                        <button type="button" class="button is-ghost has-text-danger remove is-small">
                            <span class="icon">
                                <span class="material-symbols-outlined is-size-6">
                                    delete
                                </span>
                            </span>
                        </button>
                    </td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>
<script type="module">
    $(document).ready(function() {
        const $context = $('#input-table-{{ $id }}')
        const $form = $context.parents('form')
        const $inputRow = $('tr.input-row', $context)
        const $defaultRow = $('tr.default-row', $context)
        const $inputTable = $('tbody#input-rows', $context)
        const $addButton = $('button#add', $context);

        //bind on keypress enter
        const onInputKey = function(e) {
            if (e.keyCode == 13) {
                //enter is pressed
                const $this = $(this)
                const $next = $this.closest('td').next(':not(.action)')
                if ($next.length > 0) {
                    //next column
                    $('input.input', $next).trigger('focus')
                } else {
                    //last column, add new row
                    $addButton.trigger('click')
                }
            }
        }
        $('input.input', $inputRow).on('keypress', onInputKey)
        $('input.input', $defaultRow).on('keypress', onInputKey)

        //add input row
        const addRow = () => {
            //create clone
            const $row = $inputRow.clone(true)
            $('input', $row).removeAttr('disabled')
            $row.removeClass('input-row')
            $inputTable.append($row)
            $('input:first', $row).trigger('focus')
        }
        $addButton.on('click', addRow)

        $('button#clear', $context).on('click', function() {
            if (confirm("This will remove all rows. Are you sure you want to perform this?")) {
                $inputTable.empty();
            }
        });

        //remove input row 
        $('button.remove', $context).on('click', function() {
            $(this).closest('tr').remove()
        })

        //prevent form submit on enter
        $form.bind("keypress", function(e) {
            if (e.keyCode == 13) {
                return false;
            }
        });
    });
</script>
