<div>
    <div class="field">
        @if ($getProcessedLabel() !== false)
            <label for="{{ $id }}" class="label">{{ $getProcessedLabel() }}</label>
        @endif

        <div class="control is-expanded choice-container" wire:ignore>
            <div class="select is-fullwidth {{ $multiple ? 'is-multiple' : '' }}">
                <select {{ $multiple ? 'multiple' : '' }} name="{{ $multiple ? $name . '[]' : $name }}"
                    id="{{ $id }}" {{ $attributes->except('options') }} data-choice="true">

                    @if ($placeholder && !$multiple)
                        <option value="">{{ $placeholder }}</option>
                    @endif

                    @forelse ($options as $key => $option)
                        @if (is_array($option))
                            {{-- Grouped options --}}
                            <optgroup label="{{ $key }}">
                                @foreach ($option as $optionKey => $optionValue)
                                    <option value="{{ $optionKey }}" @selected($isSelected($optionKey))>
                                        {{ $optionValue }}
                                    </option>
                                @endforeach
                            </optgroup>
                        @else
                            {{-- Regular options --}}
                            <option value="{{ $key }}" @selected($isSelected($key))>
                                {{ $option }}
                            </option>
                        @endif
                    @empty
                        @if (!$placeholder)
                            <option value="" disabled>No options available</option>
                        @endif
                    @endforelse
                </select>
            </div>
        </div>

        @if ($hint)
            <p class="help is-info">{{ $hint }}</p>
        @endif

        @error($name)
            <p class="help is-danger">{{ $message }}</p>
        @enderror
    </div>

    <script type="module">
        document.addEventListener('DOMContentLoaded', function() {
            const selectElement = document.getElementById('{{ $id }}');
            if (selectElement && typeof window.Choices !== 'undefined') {
                const config = @json(json_decode($choicesConfig));
                const choices = new window.Choices(selectElement, config);
                const isMultiple = {{ $multiple ? 'true' : 'false' }};

                // Listen for changes and dispatch events for Livewire
                const onChoiceChange = function(event) {
                    const selectedValues = choices.getValue(true);
                    if (window.Livewire) {
                        window.Livewire.dispatch('SelectChoiceUpdated:{{ $id }}', {
                            value: isMultiple ? selectedValues : selectedValues[0] || null
                        });
                    }
                };
                selectElement.addEventListener('change', onChoiceChange);

                if (window.Livewire) {
                    // clear choices on Livewire event
                    Livewire.on('SelectChoiceReset:{{ $id }}', () => {
                        choices.removeActiveItems();
                    });

                    // remove specific value from selection on Livewire event
                    Livewire.on('SelectChoiceRemoveValue:{{ $id }}', ({
                        value
                    }) => {
                        if (!value) return;
                        if (value instanceof Array) {
                            value.forEach(val => choices.removeActiveItemsByValue(val));
                            return;
                        }
                        choices.removeActiveItemsByValue(value);
                    });
                }

                // Store instance globally for external access
                window['choices_{{ $id }}'] = choices;
            }
        });
    </script>
</div>
