<?php

return [

  /**
   * List of fonts to be used in the rich text editor
   */
  'richtext' => [
    'fonts' => [
      'monospace',
      'sans-serif',
      'serif',
    ],
  ],

  /**
   * Keys required for Google reCaptcha
   */
  'recaptcha' => [
    /**
     * Default version for reCaptcha
     * 
     * Values allowed - v3 | ve
     */
    'version' => env('GOOGLE_RECAPTCHA_VERSION', 'v3'),

    /**
     * v3 parameters
     */
    'v3' => [
      'sitekey' => env('GOOGLE_RECAPTCHA_SITE_KEY', ''),
      'secret' => env('GOOGLE_RECAPTCHA_SECRET_KEY', ''),
    ],

    /**
     * Enterprise edition parameters
     */
    've' => [
      'apikey' => env('GOOGLE_RECAPTCHA_API_KEY', ''), //API key associated with the current project
      'project_id' => env('GOOGLE_RECAPTCHA_PROJECT_ID', ''),  //Google Cloud project ID
      'key' => env('GOOGLE_RECAPTCHA_KEY', ''), //reCAPTCHA key associated with the site/app
      'action' => env('GOOGLE_RECAPTCHA_ACTION', 'LOGIN'), //reCAPTCHA key associated with the site/app
    ]
  ],
];
