<div>
    <div class="field">
        @if ($getProcessedLabel() !== false)
            <label for="{{ $id }}" class="label">{{ $getProcessedLabel() }}</label>
        @endif

        <div class="control is-expanded choice-container" wire:ignore>
            <div class="select is-fullwidth {{ $multiple ? 'is-multiple' : '' }}">
                <select {{ $multiple ? 'multiple' : '' }} name="{{ $multiple ? $name . '[]' : $name }}"
                    id="{{ $id }}" {{ $attributes->except('options') }} data-choice="true">

                    @if ($placeholder && !$multiple)
                        <option value="">{{ $placeholder }}</option>
                    @endif

                    @forelse ($options as $key => $option)
                        @if (is_array($option))
                            {{-- Grouped options --}}
                            <optgroup label="{{ $key }}">
                                @foreach ($option as $optionKey => $optionValue)
                                    <option value="{{ $optionKey }}" @selected($isSelected($optionKey))>
                                        {{ $optionValue }}
                                    </option>
                                @endforeach
                            </optgroup>
                        @else
                            {{-- Regular options --}}
                            <option value="{{ $key }}" @selected($isSelected($key))>
                                {{ $option }}
                            </option>
                        @endif
                    @empty
                        @if (!$placeholder)
                            <option value="" disabled>No options available</option>
                        @endif
                    @endforelse
                </select>
            </div>
        </div>

        @if ($hint)
            <p class="help is-info">{{ $hint }}</p>
        @endif

        @error($name)
            <p class="help is-danger">{{ $message }}</p>
        @enderror
    </div>

    <script type="module">
        document.addEventListener('DOMContentLoaded', function() {
            if (typeof window.SelectChoice === 'undefined') {
                console.warn('SelectChoice: SelectChoice class not found.');
                return;
            }
            const choicesConfig = @json($choicesConfig);
            const isMultiple = {{ $multiple ? 'true' : 'false' }};
            const dispatchGenericEvent = {{ $dispatchGenericEvent ? 'true' : 'false' }};
            const debug = false;

            // Create and initialize the SelectChoice instance
            const selectChoiceInstance = window.SelectChoice.create('{{ $id }}', choicesConfig,
                isMultiple, dispatchGenericEvent, debug);

            // Create and initialize the SelectChoice instance
            const selectChoiceInstance = window.SelectChoice.create('{{ $id }}', choicesConfig,
                selectChoiceConfig);

            // Store instance globally for debugging/access if needed
            window[`selectChoice_{{ $id }}`] = selectChoiceInstance;
        });
    </script>
</div>
