<?php

namespace V360\FormComponents\View\Components;

use Illuminate\View\Component;
use Illuminate\Support\Str;

class File extends Component
{
  public string $name;
  public ?string $label = null;
  public ?string $placeholder = null;
  public string $id;

  /**
   * Type of document - pdf | excel | image
   *
   * @var string|null
   */
  public ?string $type = null;
  public string $accept;
  public bool $box;
  public ?string $filename = null;
  public ?string $hint = null;

  /**
   * Create a new component instance
   *
   * @param string $name
   * @param mixed $label
   * @param string $placeholder
   * @param string|null $id
   * @param string|null $type - pdf | excel | image | zip
   * @param bool $box - whether to show the file in a box or not
   * @param string|null $filename - name of the file to be displayed
   * @param string|null $hint - additional information about the file input
   */
  public function __construct(
    string $name,
    mixed $label = null,
    string $placeholder = 'Choose a file',
    ?string $id = null,
    ?string $type = null,
    bool $box = false,
    ?string $filename = null,
    ?string $hint = null
  ) {
    $this->name = $name;
    $this->label = $label ? $label : ($label === false ? false : Str::title(str_replace('_', ' ', $name)));
    $this->placeholder = $placeholder;
    $this->box = $box;
    $this->id = $id ? $id : str_replace('_', '-', $name);
    switch ($type) {
      case 'pdf':
        $this->accept = '.pdf';
        break;
      case 'excel':
        $this->accept = '.xls,.xlsx';
        break;
      case 'image':
        $this->accept = 'image/*';
        break;
      case 'zip':
        $this->accept = 'application/zip, application/x-zip-compressed, multipart/x-zip';
        break;
      default:
        $this->accept = '*';
        break;
    }
    $this->filename = $filename;
    $this->hint = $hint;
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vform::components.file');
  }
}
