<?php

namespace V360\FormComponents\View\Components;

use Illuminate\Support\Str;
use Illuminate\View\Component;
use Illuminate\Support\Collection;


class DynamicSelect extends Component
{
  public string $name;
  public $options;
  public $route;
  public string $child;
  public ?string $value = null;
  public string $class;
  public string $id;
  public ?string $label = null;
  public ?string $placeholder = null;
  public ?string $hint = null;
  public ?string $icon = null;

  /**
   * Create a new component instance
   *
   * @param string $name
   * @param mixed $route - route name or array with route name and parameters
   * @param string $child - child key in the response data
   * @param mixed $options - options for the select, can be an array or a Collection
   * @param string|null $value - selected value
   * @param string|null $id - HTML id attribute
   * @param mixed $label - label for the select, can be a string or false to hide it
   * @param string|null $classes - additional CSS classes for the select
   * @param string $placeholder - placeholder text for the select
   * @param string|null $hint - hint text to display below the select
   * @param string|null $icon - icon to display in the select
   */
  public function __construct(
    string $name,
    mixed $route,
    string $child,
    mixed $options = [],
    ?string $value = null,
    ?string $id = null,
    mixed $label = null,
    ?string $classes = null,
    string $placeholder = 'Select',
    ?string $hint = null,
    ?string $icon = null,
  ) {
    $this->name = $name;
    if ($options instanceof Collection) {
      $this->options = $options->toArray();
    } else {
      $this->options = $options;
    }
    $this->value = $value;
    $this->id = $id ? $id : str_replace('_', '-', $name);
    $this->label = $label ? $label : ($label === false ? false : Str::title(str_replace('_', ' ', $name)));
    $this->class = "custom-select $classes";
    if (is_array($route)) {
      $this->route = route($route[0], $route[1]);
    } else {
      $this->route = route($route);
    }
    $this->child = $child;
    $this->hint = $hint;
    $this->placeholder = $placeholder;
    $this->icon = $icon ?? 'dropdown';
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vform::components.dynamic-select');
  }
}
