<?php

namespace V360\FormComponents\View\Components;

use Illuminate\Support\Str;
use Illuminate\View\Component;

class Text extends Component
{

  public string $name;
  public ?string $value = null;
  public string $id;
  public ?string $label = null;
  public string $icon;
  public string $class;
  public ?string $hint = null;
  public ?string $placeholder = null;
  public ?string $addon = null;

  /**
   * Create a new component instance
   *
   * @param string $name
   * @param mixed $value
   * @param string|null $id
   * @param mixed $label
   * @param mixed $icon - true, false, 'text_fields'
   * @param string|null $placeholder
   * @param string|null $classes
   * @param string|null $hint
   * @param string|null $addon
   */
  public function __construct(
    string $name,
    mixed $value = null,
    ?string $id = null,
    mixed $label = null,
    mixed $icon = 'text_fields',
    ?string $placeholder = null,
    ?string $classes = null,
    ?string $hint = null,
    ?string $addon = null
  ) {
    $this->name = $name;
    $this->value = $value;
    $this->id = $id ? $id : str_replace('_', '-', $name);
    $this->label = $label ? $label : ($label === false ? false : Str::title(str_replace('_', ' ', $name)));
    $this->icon = $icon;
    $this->class = "input $classes";
    if ($this->label === false) {
      $this->placeholder = Str::title(str_replace('_', ' ', $name));
    }
    if ($placeholder) {
      $this->placeholder = $placeholder;
    }
    $this->hint = $hint;
    $this->addon = $addon;
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vform::components.text');
  }
}
