<?php

namespace V360\FormComponents\View\Components;

use Illuminate\Support\Str;
use Illuminate\View\Component;

/**
 * Autocomplete component
 * 
 * - Events
 *  - Listens
 *    - 'AutoCompleteInit:name` <value: string, label:string>
 *    - `AutoCompleteReset` <autoFields: []>
 *    - `AutoCompleteItems:name` <items: []>
 *  - Dispatches
 *    - `AutoCompleteSet:name` <value: string>
 */
class Autocomplete extends Component
{
  /**
   * Create a new component instance
   *
   * @param string $name Name of the input
   * @param mixed $options Options for the autocomplete Array or Collection
   * @param string|null $value Value of the input
   * @param string|null $id ID of the input, in case of not provided, slug version of the name will be used
   * @param string|null $label Label of the input, in case of not provided, title version of the name will be used
   * @param string|null $placeholder Placeholder of the input, default is "Select"
   * @param string|null $hint Hint of the input
   * @param boolean $startSearch Search by start or not, default is false
   * @param boolean $isLivewire Livewire component or not, default is false
   */
  public function __construct(
    public string $name,
    public mixed $options,
    public ?string $value = null,
    public ?string $id = null,
    public ?string $label = null,
    public ?string $placeholder = null,
    public ?string $hint = null,
    public bool $startSearch = false,
    public bool $isLivewire = false,
  ) {
    $this->id = $id ? $id : str_replace('_', '-', $name);
    $this->label = $label ? $label : ($label === false ? false : Str::title(str_replace('_', ' ', $name)));
    $this->placeholder = $placeholder ? $placeholder : "Select";
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vform::components.autocomplete');
  }
}
