<div>
    <div class="field">
        @if ($label)
            <label for="{{ $id }}" class="label">{{ $label }}</label>
        @endif
        <div class="control has-icons-right">
            @php
                $attr = $attributes->merge([
                    'id' => $id,
                    'class' => $class,
                    'placeholder' => $placeholder,
                ]);
                if ($attributes->has('disabled') && !$attributes->get('disabled')) {
                    $attr = $attr->except(['disabled']);
                }
                $attr = $attr->getAttributes();
            @endphp
            {{ html()->input('number', $name, $value)->attributes($attr) }}
            <span class="icon is-small is-right">
                <span class="material-symbols-outlined is-size-6">
                    {{ $icon }}
                </span>
            </span>
        </div>
    </div>
    @if (isset($hint))
        <p class="help is-info">{{ $hint }}</p>
    @endif
    @error($name)
        <p class="help is-danger">{{ $message }}</p>
    @enderror
</div>
