<?php

namespace V360\FormComponents\View\Components;

use Illuminate\Support\Str;
use Illuminate\View\Component;
use Illuminate\Support\Collection;

class Select extends Component
{

  public string $name;
  public ?string $value = null;
  public $options;
  public string $id;
  public ?string $label = null;
  public $placeholder = null;
  public bool $multiple;
  public string $icon;
  public string $class;
  public ?string $hint = null;

  /**
   * Create a new component instance
   *
   * @param string $name
   * @param mixed $options
   * @param mixed $value
   * @param string|null $id
   * @param mixed $label
   * @param mixed $placeholder
   * @param mixed $icon
   * @param bool $multiple
   * @param string|null $classes
   * @param string|null $hint
   * @param bool $sort
   */
  public function __construct(
    string $name,
    mixed $options = [],
    ?string $value = null,
    ?string $id = null,
    mixed $label = null,
    mixed $placeholder = 'Select',
    mixed $icon = 'dropdown',
    bool $multiple = false,
    ?string $classes = null,
    ?string $hint = null,
    bool $sort = false,
  ) {
    $this->name = $name;
    if ($options instanceof Collection) {
      $this->options = $options->toArray();
    } else {
      $this->options = $options;
    }
    if ($sort) {
      asort($this->options, SORT_REGULAR);
    }
    $this->value = $value;
    $this->id = $id ? $id : str_replace('_', '-', $name);
    $this->label = $label ? $label : ($label === false ? false : Str::title(str_replace('_', ' ', $name)));
    $this->icon = $icon;
    $this->multiple = $multiple ? "multiple" : "";
    $this->class = 'custom-select ' . $classes;
    $this->placeholder = $placeholder;
    $this->hint = $hint;
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vform::components.select');
  }
}
