<div class="select-grid-wrapper" id="{{ $id }}-container">
    <div class="field">
        @if ($getProcessedLabel() !== false)
            <label class="label">{{ $getProcessedLabel() }}</label>
        @endif

        <div class="select-grid-container" @style(["grid-template-columns: repeat({$getColumnsPerRow()}, {$optionWidth}px)", "grid-template-rows: repeat({$gridRows}, auto)"])>
            @foreach ($options as $index => $option)
                @php
                    $optionValue = is_array($option) ? $option['value'] ?? ($option[0] ?? '') : $option;
                    $optionLabel = is_array($option) ? $option['label'] ?? ($option[1] ?? $optionValue) : $optionValue;
                    $optionUrl = is_array($option) ? $option['url'] ?? ($option[2] ?? '') : '';
                    $inputId = "{$id}_{$index}";
                    $formName = $multiple ? "{$name}[]" : $name;
                @endphp

                <input type="{{ $multiple ? 'checkbox' : 'radio' }}" name="{{ $formName }}" value="{{ $optionValue }}"
                    id="{{ $inputId }}" class="select-grid-input" @if ($isSelected($optionValue)) checked @endif
                    {{ $attributes->whereStartsWith('wire:') }}>

                <label for="{{ $inputId }}" class="select-grid-option"
                    style="width: {{ $optionWidth }}px; max-width: 100%;" title="{{ $optionLabel }}">
                    @if ($optionUrl)
                        <img src="{{ $optionUrl }}" alt="{{ $optionLabel }}" class="select-grid-image"
                            loading="lazy">
                    @else
                        <div>{{ $optionLabel }}</div>
                    @endif
                </label>
            @endforeach
        </div>

        @if ($hint)
            <p class="help is-info">{{ $hint }}</p>
        @endif

        @error($name)
            <p class="help is-danger">{{ $message }}</p>
        @enderror
    </div>
</div>
