<div>

    <div class="field">
        @if ($getProcessedLabel() !== false)
            <label class="label">{{ $getProcessedLabel() }}</label>
        @endif

        <div class="control is-expanded select-check-container" wire:ignore>
            <div class="select is-fullwidth {{ $multiple ? 'is-multiple' : '' }}">
                <select {{ $multiple ? 'multiple' : '' }} name="{{ $multiple ? $name . '[]' : $name }}"
                    id="{{ $id }}" {{ $attributes->except('options') }}>

                    @forelse ($options as $key => $option)
                        @if (is_array($option))
                            <optgroup label="{{ $key }}">
                                @foreach ($option as $optionKey => $optionValue)
                                    <option value="{{ $optionKey }}" @selected($isSelected($optionKey))>
                                        {{ $optionValue }}
                                    </option>
                                @endforeach
                            </optgroup>
                        @else
                            <option value="{{ $key }}" @selected($isSelected($key))>
                                {{ $option }}
                            </option>
                        @endif
                    @empty
                        @if (!$placeholder)
                            <option value="" disabled>No options available</option>
                        @endif
                    @endforelse
                </select>
            </div>
        </div>

        @if ($hint)
            <p class="help is-info">{{ $hint }}</p>
        @endif

        @error($name)
            <p class="help is-danger">{{ $message }}</p>
        @enderror
    </div>

    <script type="module">
        document.addEventListener('DOMContentLoaded', function() {
            if (typeof window.SelectCheck === 'undefined') {
                console.warn('SelectCheck: SelectCheck class not found.');
                return;
            }
            const config = @json($virtualSelectConfig);
            const isMultiple = {{ $multiple ? 'true' : 'false' }};

            // Create and initialize the SelectCheck instance
            const selectCheckInstance = window.SelectCheck.create('{{ $id }}', config, isMultiple);

            // Store instance globally for debugging/access if needed
            window[`selectCheck_{{ $id }}`] = selectCheckInstance;
        });
    </script>
</div>
