<?php

namespace V360\ActionComponents\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class CollapsibleFilterActions extends Component
{
  /**
   * Create a new component instance.
   */
  public function __construct(
    public bool $filterApplied,
    public string $label = 'Filter',
    public string $icon = 'filter_list',
    public string $panel = 'collapsible-filter-panel',
    public string $resetAction = 'resetFilters'
  ) {
    //
  }

  /**
   * Get the view / contents that represent the component.
   */
  public function render(): View|Closure|string
  {
    return view('vaction::components.collapsible-filter-actions');
  }
}
