<?php

namespace V360\ActionComponents\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class ButtonDelete extends Component
{
  public string $icon;
  /**
   * Create a new component instance.
   */
  public function __construct(
    public string $action,
    public bool $isArchive = false,
    public ?string $confirmMessage = null,
    public ?string $class = null,
    public ?string $title = null,
  ) {
    $this->confirmMessage = $confirmMessage ?? (
      $this->isArchive ?
      'Are you sure you want to archive this record?' :
      'Are you sure you want to delete this record?'
    );
    $this->icon = $isArchive ? 'archive' : 'delete';
    $this->title = $title ?? ($isArchive ? 'Archive' : 'Delete');
  }

  /**
   * Get the view / contents that represent the component.
   */
  public function render(): View|Closure|string
  {
    return view('vaction::components.button-delete');
  }
}
