<div wire:ignore>
    <a id="{{ $id }}" @class(['button m-4 is-hidden', "is-{$color}"]) @style(['position:fixed; bottom:0;', "{$position}:0", "z-index:{$zIndex}", "border-radius: 50%; width: {$size}px; height: {$size}px;"]) data-target="{{ $target }}"
        title="{{ $title }}">
        <span class="icon">
            <span class="material-symbols-outlined">
                arrow_upward
            </span>
        </span>
    </a>
    <script type="module">
        document.addEventListener('DOMContentLoaded', function() {
            const button = document.getElementById('{{ $id }}')
            let target = '{{ $target }}'
            if (target) {
                target = document.getElementById('{{ $target }}')
            } else {
                target = document.body
            }

            function scrollToElement(target) {

                // Scroll behavior (optional)
                const behavior = arguments[1] || 'smooth'; // Default to smooth scrolling

                // Check if target is a string (element ID) or an actual DOM element
                if (typeof target === 'string') {
                    if (target == 'top') {
                        // Scroll to the target element or top of the window
                        window.scrollTo({
                            top: 0,
                            left: 0,
                            behavior: behavior
                        });
                        return;
                    } else {
                        const element = document.getElementById(target);
                        if (element) {
                            target = element;
                        } else {
                            console.error(`Element with ID "${target}" not found.`);
                            return; // Exit function if element not found
                        }
                    }
                }
                // Scroll to the target element or top of the window
                target.scrollIntoView({
                    behavior: behavior
                });
            }
            button.addEventListener('click', function() {
                scrollToElement(target)
            })
            window.addEventListener('scroll', function() {
                const scrollTop = window.scrollY; // Get current scroll position
                if (scrollTop > target.offsetTop && scrollTop < (target.offsetTop + target.offsetHeight)) {
                    button.classList.remove('is-hidden')
                } else {
                    button.classList.add('is-hidden')
                }
            })

        });
    </script>
</div>
