# Action Components
A package for action components based on Laravel and Bulma.

## Dependencies

- [Laravel Collective](https://laravelcollective.com/)
- [jQuery](https://jquery.com/)
- [BulmaQuickView](https://wikiki.github.io/components/quickview/)

## Installation

```
$ composer require v360-tech/components-action
```

In case your Laravel version does NOT autoload the packages, add the service provider to config/app.php:

```
V360\ActionComponents\ActionComponentsServiceProvider::class,
```

## Export

### To publish views
```
php artisan vendor:publish --provider="V360\ActionComponents\ActionComponentsServiceProvider" --tag="vaction"
```

## Use

This package implements following list of components.

| Element         | Tag                          |
| :-------------- | ---------------------------- |
| Bulk Action     | \<x-vaction-bulkx />         |
| Card List       | \<x-vaction-card-list />     |
| Default Actions | \<x-vaction-defaultx />      |
| Get Request     | \<x-vaction-getx />          |
| Infinite List   | \<x-vaction-infinite-list /> |
| Modal Edit      | \<x-vaction-modal-edit />    |
| Post Request    | \<x-vaction-postx />         |
| Quick Form      | \<x-vaction-quick-form />    |
| Quick Filter    | \<x-vaction-quick-filter />  |