<?php

namespace V360\ActionComponents\View\Components;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use Illuminate\View\Component;

class ModalEdit extends Component
{
  public string $title;
  public string $id;
  public string $route;
  public Model $record;
  public array $fields;

  /**
   * Create a new component instance.
   *
   * @param string $title
   * @param array $route
   * @param Model $record
   * @param array $fields
   * @return void
   */
  public function __construct(
    string $title,
    string $route,
    Model $record,
    array $fields
  ) {
    //generate random id
    $this->id = Str::uuid();
    $this->title = $title;
    $this->route = $route;
    $this->record = $record;
    $this->fields = $fields;
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vaction::components.modal-edit');
  }
}
