<?php

namespace V360\ActionComponents\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class CollapsibleFilter extends Component
{
  /**
   * Create a new component instance.
   */
  public function __construct(
    public array $filters,
    public array $fields,
    public array $fieldHints = [],
    public string $panelLabel = 'Filter',
    public string $panel = 'collapsible-filter-panel',
    public string $modelProperty = 'filterValues',
    public string $iconOn = 'filter_list',
    public string $iconOff = 'filter_list_off'
  ) {
    //
  }

  /**
   * Get the view / contents that represent the component.
   */
  public function render(): View|Closure|string
  {
    return view('vaction::components.collapsible-filter');
  }
}
