<div class="control">
    <form action="{{ $route }}" method="POST" @class(['confirm' => $confirm, 'processing' => $processing])>
        @csrf
        @method('POST')
        @if ($postData)
            @foreach ($postData as $key => $value)
                <input type="hidden" name="{{ $key }}" value="{{ $value }}">
            @endforeach
        @endif
        <button type="submit" class="button is-ghost has-text-{{ $color }}" title="{{ $tooltip }}">
            <span class="icon">
                @if (Str::startsWith($icon, 'fa'))
                    <i class="fas is-small {{ $icon }}"></i>
                @else
                    <span class="material-symbols-outlined is-size-6">
                        {{ $icon }}
                    </span>
                @endif
            </span>
            @if ($title)
                <span>{{ $title }}</span>
            @endif
        </button>
    </form>
</div>
