<div class="columns is-multiline">
    @foreach ($records as $record)
        <div class="column {{ $size }}">
            <div class="box">
                <p class="subtitle">{{ $record->$title }}</p>
                <div class="level is-mobile">
                    <div class="level-left">
                        <div class="level-item">
                            @isset($subtitle)
                                <p class="subtitle is-6 m-0">
                                    {{ $record->$subtitle }}
                                </p>
                            @endisset
                        </div>
                    </div>
                    <div class="level-right">
                        <div class="level-item">
                            <div class="field is-grouped is-grouped-right are-small">
                                @if ($show)
                                    <div class="control">
                                        <a class="button is-ghost has-text-link"
                                            href="{{ route($routePrefix . '.show', $record->id) }}">
                                            <span class="icon">
                                                <span class="material-symbols-outlined is-size-6">
                                                    info_i
                                                </span>
                                            </span>
                                        </a>
                                    </div>
                                @endif

                                @if ($edit)
                                    <div class="control">
                                        <a class="button is-ghost has-text-link"
                                            href="{{ route($routePrefix . '.edit', $record->id) }}">
                                            <span class="icon">
                                                <span class="material-symbols-outlined is-size-6">
                                                    edit
                                                </span>
                                            </span>
                                        </a>
                                    </div>
                                @endif

                                @if ($delete)
                                    <div class="control">
                                        <form action="{{ route($routePrefix . '.destroy', $record->id) }}"
                                            method="POST" class="confirm">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="button is-ghost has-text-danger">
                                                <span class="icon">
                                                    <span class="material-symbols-outlined is-size-6">
                                                        delete
                                                    </span>
                                                </span>
                                            </button>
                                        </form>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
</div>
