<?php

namespace V360\ActionComponents\View\Components;

use Illuminate\View\Component;
use Illuminate\Support\Str;

class QuickFilter extends Component
{

  public $fields;
  public $route;
  public $id;
  public $filters;

  /**
   * Create a new component instance
   *
   * @param Collection $fields List of fields
   * @param string $route Route name for indexing
   * @param array $filters
   */
  public function __construct($fields, $route, $filters = [])
  {
    $this->fields = $fields;
    $this->route = $route;
    $this->filters = $filters;
    $this->id = Str::uuid();
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vaction::components.quick-filter');
  }
}
