<div class="modal-container">
    <div class="control">
        <button class="button is-ghost has-text-link open-modal px-3" data-target="{{ $id }}">
            <span class="icon">
                <span class="material-symbols-outlined is-size-6">
                    edit
                </span>
            </span>
        </button>
    </div>
    <div class="modal" id="{{ $id }}">
        <div class="modal-background close-modal"></div>
        <form action="{{ $route }}" method="POST">
            @csrf
            @method('PATCH')
            <div class="modal-card">
                <header class="modal-card-head">
                    <p class="modal-card-title has-text-info">
                        {{ $title }}
                    </p>
                    <button class="delete close-modal" aria-label="close" type="button"></button>
                </header>
                <section class="modal-card-body">
                    @foreach ($fields as $name => $type)
                        <div class="block">
                            @switch($type)
                                @case('text')
                                    <x-vform-text :name="$name" value="{{ $record->{$name} }}" />
                                @break

                                @case('number')
                                    <x-vform-number :name="$name" value="{{ $record->{$name} }}" />
                                @break

                                @default
                                    <x-vform-text :name="$name" value="{{ $record->{$name} }}" />
                            @endswitch
                        </div>
                    @endforeach
                </section>
                <footer class="modal-card-foot">
                    <button class="button is-link" type="submit">
                        <span class="icon">
                            <span class="material-symbols-outlined is-size-6">
                                save
                            </span>
                        </span>
                        <span>Save</span>
                    </button>
                    <button class="button is-light close-modal" type="button">
                        <span class="icon">
                            <span class="material-symbols-outlined is-size-6">
                                close
                            </span>
                        </span>
                        <span>Cancel</span>
                    </button>
                </footer>
            </div>
        </form>
    </div>
</div>
