<div>
    <script type="module">
        let $table;

        $(document).ready(function() {
            $table = $('{{ $recordTableId }}');
            $('input[name=select_all]', $table).click(function() {
                const context = $(this).parents('table');
                if ($(this).is(":checked")) {
                    $('input[name=record]', context).prop("checked", true).trigger('change');
                } else {
                    $('input[name=record]', context).prop("checked", false).trigger('change');
                }
            });

            //update background color on checked
            $('input[name=record]', $table).on('change', function() {
                const $this = $(this)
                if ($this.is(':checked')) {
                    $this.addClass('has-background-color')
                } else {
                    $this.removeClass('has-background-color')
                }
            });
        });

        const getSelectedRecords = () => {
            let selected = [];
            $('input[name=record]:checked', $table).each(function() {
                const id = $(this).data('id');
                selected.push(id);
            });
            return selected;
        };

        const submitForm = (action) => {
            const $form = $('#' + action);
            const selected = getSelectedRecords();
            if (selected.length === 0) {
                showMessage("Select at lease one record", 'error');
                event.preventDefault();
                return;
            }
            const ids = JSON.stringify(selected);
            $('input[name=ids]', $form).val(ids);
            $form.submit();
        };
    </script>
    @foreach ($actions as $action => $label)
        @php
            $route = $routePrefix . '.' . $action;
        @endphp
        <div>
            <form action="{{ route($route, $pathParameters ?? null) }}" method="POST" class="bulk-form confirm"
                id="{{ $action }}">
                @csrf
                @method('POST')
                <input type="hidden" name="ids">
            </form>
        </div>
    @endforeach
    <div class="dropdown is-hoverable mr-3">
        <div class="dropdown-trigger">
            <button class="button is-link" aria-haspopup="true" aria-controls="dropdown-menu">
                <span class="icon">
                    <span class="material-symbols-outlined is-size-6">
                        event_list
                    </span>
                </span>
                <span class="icon">
                    <span class="material-symbols-outlined is-size-6">
                        arrow_drop_down
                    </span>
                </span>
            </button>
        </div>
        <div class="dropdown-menu" id="dropdown-menu" role="menu">
            <div class="dropdown-content">
                @foreach ($actions as $action => $label)
                    <a class="dropdown-item" onclick="submitForm('{{ $action }}')">
                        {{ $label }}
                    </a>
                @endforeach
            </div>
        </div>
    </div>
</div>
