<?php

namespace V360\ActionComponents\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class Button extends Component
{
  public $iconSize;
  /**
   * Create a new component instance.
   */
  public function __construct(
    public string $class = 'is-link',
    public ?string $icon = null,
    public bool $disabled = false,
    public string $size =  'normal'
  ) {
    //
    $this->iconSize = $size == 'normal' ? 6 : 7;
  }

  /**
   * Get the view / contents that represent the component.
   */
  public function render(): View|Closure|string
  {
    return view('vaction::components.button');
  }
}
