<?php

namespace V360\ActionComponents;

use Exception;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\ServiceProvider;
use V360\ActionComponents\View\Components\Bulkx;
use V360\ActionComponents\View\Components\CardList;
use V360\ActionComponents\View\Components\CollapsibleFilter;
use V360\ActionComponents\View\Components\CollapsibleFilterActions;
use V360\ActionComponents\View\Components\Defaultx;
use V360\ActionComponents\View\Components\Getx;
use V360\ActionComponents\View\Components\InfiniteList;
use V360\ActionComponents\View\Components\ModalEdit;
use V360\ActionComponents\View\Components\Postx;
use V360\ActionComponents\View\Components\QuickFilter;
use V360\ActionComponents\View\Components\QuickForm;

class ActionComponentsServiceProvider extends ServiceProvider
{
  /**
   * Register service provider
   *
   * @return void
   */
  public function register()
  {

    if ($this->app->runningInConsole()) {
      // Publish view components
      $this->publishes([
        __DIR__ . '/../src/View/Components/' => app_path('View/Components/vaction'),
        __DIR__ . '/../resources/views/components/' => resource_path('views/components/vaction'),
      ], 'vaction');
    }
  }

  /**
   * Initialization
   *
   * @return void
   */
  public function boot()
  {

    // ... other things
    $this->loadViewsFrom(__DIR__ . '/../resources/views', 'vaction');

    //regiter components
    $this->loadViewComponentsAs('vaction', [
      Bulkx::class,
      CardList::class,
      Defaultx::class,
      Getx::class,
      InfiniteList::class,
      ModalEdit::class,
      Postx::class,
      QuickForm::class,
      QuickFilter::class,
      CollapsibleFilter::class,
      CollapsibleFilterActions::class,
    ]);
  }

  /**
   * Prepare ute
   *
   * @param mixed $route
   * @return array
   */
  public static function prepareRoute(mixed $route): array
  {
    try {
      $params = [];
      if (is_string($route)) {
        $name = $route;
      } else {
        //array
        switch (count($route)) {
          case 0:
            throw new Exception("Route can not be empty", 1);
          case 1:
            $name = $route[0];
            break;
          case 2:
            $name = $route[0];
            $params = $route[1];
            break;
          default:
            $name = array_shift($route);
            $params = $route;
            break;
        }
      }
    } catch (\Throwable $th) {
      Log::error(__CLASS__, [$route, $th->getMessage(), $th->getLine()]);
      throw new Exception("Route could not be processed", 1);
    }
    return [$name, $params];
  }
}
