<?php

namespace V360\ActionComponents\View\Components;

use Illuminate\View\Component;

/**
 * Component to list record using Ajax. Should implement the following.
 *  - Rendering of records should be implemented by view includes as it will be used in controller to generate next records.
 *  - Method specified by route should return Ajax response.
 *  - In case callback functions are required, 
 *      - Name of that function should be infiniteCallback();
 *      - Function should be defined outside the component and should be available in window context
 *  - Usage is limited to one per view in case it requires callback.
 *  - Sample usage - UserController@index
 */
class InfiniteList extends Component
{

  public string $route;
  public array $filters;
  public string $tableId;

  /**
   * Create a new component instance.
   *
   * @param string $route - Controller route action name
   * @param array $filters - Array of filter parameters
   * @param string $tableId - Id of record table
   */
  public function __construct(
    string $route,
    array $filters,
    string $tableId
  ) {
    //
    $this->route = $route;
    $this->filters = $filters;
    $this->tableId = $tableId;
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\Contracts\View\View|\Closure|string
   */
  public function render()
  {
    return view('vaction::components.infinite-list');
  }
}
