<?php

namespace V360\ActionComponents\View\Components;

use Illuminate\View\Component;
use Illuminate\Support\Str;

class Getx extends Component
{

  public string $route;
  public string $icon;
  public string $color;
  public ?string $title = null;
  public ?string $tooltip = null;
  public string $target;

  /**
   *  Create a new component instance.
   *
   * @param string $route
   * @param string $icon
   * @param string $color
   * @param string $title
   * @param string $tooltip
   * @param string $tooltipColor
   * @param string $target - _blank, _self, _top, _parent
   */
  public function __construct(
    string $route,
    string $icon = 'fa-check',
    string $color = 'is-primary',
    string $title = null,
    string $tooltip = null,
    string $target = '_self'
  ) {
    $this->route = $route;
    $this->icon = $icon;
    $this->color = Str::replace('is-', '', $color);
    $this->title = $title;
    $this->tooltip = $tooltip;
    $this->target = $target;
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vaction::components.getx');
  }
}
