<div>

    {{ $slot }}

    <x-vshow-loading message="Fetching Data" />

    <div class="divider">
        <a href="#" class="button is-link is-outlined is-centered" id="btn-fetch-more">
            Load More
        </a>
    </div>

    <script type="module">
        $(document).ready(function() {

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('input[name=_token]').val()
                }
            });

            let page = 1;
            const $more = $('a#btn-fetch-more');

            //fetch records for 
            const fetchMore = () => {

                //increment page
                page++;

                //get url
                let url = prepareURL();

                //fetch records from server
                $.ajax({
                    type: "GET",
                    url: url + "page=" + page,
                    dataType: "json",
                    beforeSend: function() {
                        $('.loader-wrapper').addClass('is-active');
                    },
                    success: function(response) {
                        $('.loader-wrapper').removeClass('is-active');
                        const lastPage = response.last_page;

                        //disable if last page
                        if (page >= lastPage) {
                            $more.attr('disabled', true);
                            $more.html("No More Records");
                            $more.off('click');
                        }

                        //render records
                        const $tbody = $('tbody', $('#{{ $tableId }}'))
                        $tbody.append(response.content)

                        //bind 
                        if (infiniteCallback) {
                            infiniteCallback();
                        }
                    },
                    error: function(jqXHR, ajaxOptions, thrownError) {
                        $('.loader-wrapper').removeClass('is-active');
                        showMessage("Server Error : " + thrownError, 'error')
                    }
                });

            }
            $more.on('click', fetchMore);

            //prepare url
            const prepareURL = () => {
                let url = "{{ url($route) }}";
                if (url.includes('?')) {
                    url += '&'
                } else {
                    url += '?'
                }
                const filters = JSON.parse('<?= json_encode($filters) ?>');
                for (const key in filters) {
                    if (Object.hasOwnProperty.call(filters, key)) {
                        const value = filters[key];
                        url += key + '=' + value + "&"
                    }
                }
                return url;
            }
        })
    </script>
</div>
