<?php

namespace V360\ActionComponents\View\Components;

use Illuminate\View\Component;

class Defaultx extends Component
{
  public string $routePrefix;
  public $id;
  public bool $edit;
  public bool $show;
  public bool $delete;
  public string $deleteIcon;
  public string $deleteClass;
  public string $deleteLabel;
  public bool $isDropdown;

  /**
   * Create a new component instance.
   *
   * @param string $routePrefix
   * @param mixed $id
   * @param mixed $preId
   * @param bool $show
   * @param bool $edit
   * @param bool $delete
   * @param bool $isArchive
   * @param bool $isDropdown
   * @return void
   */
  public function __construct(
    string $routePrefix,
    $id,
    $preId = null,
    bool $show = true,
    bool $edit = true,
    bool $delete = true,
    bool $isArchive = false,
    bool $isDropdown = false
  ) {
    //
    $this->routePrefix = $routePrefix;
    if ($preId) {
      $this->id = [$preId, $id];
    } else {
      $this->id = $id;
    }
    $this->show = $show;
    $this->edit = $edit;
    $this->delete = $delete;
    $this->deleteIcon = $isArchive ? 'archive' : 'delete';
    $this->deleteClass = $isArchive ? 'success' : 'danger';
    $this->deleteLabel = $isArchive ? 'Archive' : 'Delete';
    $this->isDropdown = $isDropdown;
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vaction::components.defaultx');
  }
}
