<?php

namespace V360\ActionComponents;

use Illuminate\Support\ServiceProvider;
use V360\ActionComponents\View\Components\Bulkx;
use V360\ActionComponents\View\Components\CardList;
use V360\ActionComponents\View\Components\Defaultx;
use V360\ActionComponents\View\Components\Getx;
use V360\ActionComponents\View\Components\InfiniteList;
use V360\ActionComponents\View\Components\ModalEdit;
use V360\ActionComponents\View\Components\Postx;
use V360\ActionComponents\View\Components\QuickForm;
use V360\ActionComponents\View\Components\QuickFilter;
use Exception;
use Illuminate\Support\Facades\Log;

class ActionComponentsServiceProvider extends ServiceProvider
{
  /**
   * Register service provider
   *
   * @return void
   */
  public function register()
  {

    if ($this->app->runningInConsole()) {
      // Publish view components
      $this->publishes([
        __DIR__ . '/../src/View/Components/' => app_path('View/Components/vaction'),
        __DIR__ . '/../resources/views/components/' => resource_path('views/components/vaction'),
      ], 'vaction');
    }
  }

  /**
   * Initialization
   *
   * @return void
   */
  public function boot()
  {

    // ... other things
    $this->loadViewsFrom(__DIR__ . '/../resources/views', 'vaction');

    //regiter components
    $this->loadViewComponentsAs('vaction', [
      Bulkx::class,
      CardList::class,
      Defaultx::class,
      Getx::class,
      InfiniteList::class,
      ModalEdit::class,
      Postx::class,
      QuickForm::class,
      QuickFilter::class,
    ]);
  }

  /**
   * Prepare ute
   *
   * @param mixed $route
   * @return array
   */
  public static function prepareRoute(mixed $route): array
  {
    try {
      $params = [];
      if (is_string($route)) {
        $name = $route;
      } else {
        //array
        switch (count($route)) {
          case 1:
            $name = $route[0];
            break;
          case 2:
            $name = $route[0];
            $params = $route[1];
            break;
          default:
            throw new Exception("Invalid route parameter", 1);
            break;
        }
      }
    } catch (\Throwable $th) {
      Log::error(__CLASS__, [$route, $th->getMessage(), $th->getLine()]);
      throw new Exception("Route could not be processed", 1);
    }
    return [$name, $params];
  }
}
