<div id="quickview-panel-{{ $id }}">
    <div id="overlay-{{ $id }}" class="quick-view-overlay has-background-{{ $overlayColor }}"></div>
    <div class="quickview {{ $classes }}" id="{{ $id }}">
        <header class="quickview-header has-background-info">
            <p class="subtitle has-text-white mb-0">{{ $title }}</p>
            <span class="delete quickview-dismiss" data-dismiss="quickview"></span>
        </header>
        <div class="quickview-body">
            {{ $slot }}
        </div>
    </div>
    <button class="button is-{{ $triggerColor }} quickview-trigger" data-show="quickview"
        data-target="{{ $id }}">
        <span class="icon">
            <i class="{{ $triggerIcon }}"></i>
        </span>
        @if ($triggerLabel)
            <span>{{ $triggerLabel }}</span>
        @endif
    </button>
    <script type="application/javascript">
        $(document).ready(function() {
            const $context = $('#quickview-panel-{{ $id }}')
            const $trigger = $('button.quickview-trigger', $context)
            const $overlay = $("#overlay-{{ $id }}", $context);
            const $dismiss = $('span.quickview-dismiss', $context)

            $trigger.on('click', function() {
                $overlay.fadeIn();;
            })
            $dismiss.on('click', function() {
                $overlay.fadeOut();
            })
            $overlay.on('click', function() {
                $dismiss.trigger('click')
            })
        });
    </script>
</div>
