<?php

namespace V360\ActionComponents\View\Components;

use Illuminate\Support\Str;
use Illuminate\View\Component;

class QuickForm extends Component
{

  public $title;
  public $triggerIcon;
  public $triggerColor;
  public $triggerLabel;
  public $classes;
  public $id;
  public $overlayColor;

  /**
   * Create a new component instance
   *
   * @param string $title - Title of form
   * @param string $triggerIcon - Trigger button icon
   * @param string $triggerColor - Trigger button color (bulma color)
   * @param string $size - Size of container (normal | medium | large)
   * @param string $direction - Direction of container (left | right)
   * @param string $overlayColor - Overlay color (bulma color)
   */
  public function __construct(
    $title,
    $triggerIcon = "fas fa-plus",
    $triggerColor = "primary",
    $triggerLabel = null,
    $size = 'normal',
    $direction = 'left',
    $overlayColor = "dark"
  ) {
    $this->title = $title;
    $this->triggerIcon = $triggerIcon;
    $this->triggerColor = $triggerColor;
    $this->triggerLabel = $triggerLabel;
    $this->id = Str::uuid();

    $classes = collect();
    switch ($size) {
      case 'large':
        $classes->push('is-large');
        break;
      case 'medium':
        $classes->push('is-medium');
        break;
      default:
        break;
    }
    switch ($direction) {
      case 'left':
        $classes->push('is-left');
        break;
      default:
        break;
    }
    $this->classes = $classes->join(" ");
    $this->overlayColor = $overlayColor;
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vaction::components.quick-form');
  }
}
