<?php

namespace V360\ActionComponents\View\Components;

use Illuminate\View\Component;
use V360\ActionComponents\ActionComponentsServiceProvider;

class Postx extends Component
{

  public $route;
  public string $confirm;
  public string $icon;
  public string $color;
  public ?string $title = null;
  public ?string $tooltip = null;
  public $postData;
  public string $processing;

  /**
   * Create a new component instance.
   *
   * @param string|array $route
   * @param bool $confirm
   * @param string $icon
   * @param string $color
   * @param string $title
   * @param string $tooltip
   * @param string $tooltipColor
   * @param array|null $postData
   * @param bool $processing
   */
  public function __construct(
    $route,
    bool $confirm = false,
    string $icon = 'fa-check',
    string $color = 'is-primary',
    string $title = null,
    string $tooltip = null,
    $postData = null,
    bool $processing = false
  ) {
    $this->confirm = $confirm;
    $this->icon = $icon;
    $this->color = $color;
    $this->title = $title;
    $this->tooltip = $tooltip;
    $this->postData = $postData;
    $this->processing = $processing;

    //prepare route
    [$name, $param] = ActionComponentsServiceProvider::prepareRoute($route);
    $this->route = route($name, $param);
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vaction::components.postx');
  }
}
