<?php

namespace V360\ActionComponents\View\Components;

use Illuminate\View\Component;

class CardList extends Component
{

    public $records;
    public bool $show;
    public bool $edit;
    public bool $delete;
    public string $routePrefix;
    public string $title;
    public ?string $subtitle = null;
    public string $size = 'is-3';

    /**
     * Create a new component instance.
     *
     * @param $records
     * @param string $route
     * @param string $title
     * @param boolean $show
     * @param boolean $edit
     * @param boolean $delete
     * @param string $subtitle
     * @param string $size
     */
    public function __construct(
        $records,
        string $route,
        string $title,
        bool $show = true,
        bool $edit = true,
        bool $delete = true,
        string $subtitle = null,
        string $size = 'is-3'
    ) {
        $this->records = $records;
        $this->routePrefix = $route;
        $this->title = $title;
        $this->show = $show;
        $this->edit = $edit;
        $this->delete = $delete;
        $this->subtitle = $subtitle;
        $this->size = $size;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|string
     */
    public function render()
    {
        return view('vaction::components.card-list');
    }
}
