<div id="{{ $id }}">
    <div class="field has-addons mb-0">
        <div class="contol">
            <button class="button is-static is-radiusless" style="background: none; border:none;">
                <span class="icon">
                    <i class="fas fa-filter"></i>
                </span>
            </button>
        </div>
        @foreach ($fields as $name => $field)
            @php
                $value = $filters[$name] ?? null;
            @endphp
            @switch($field[0])
                @case('text')
                @case('number')
                    @php
                        [$type, $label, $width] = $field;
                    @endphp
                    <div class="contol" data-tooltip="{{ $label }}">
                        <input type="{{ $type }}" name="{{ $name }}" value="{{ $value }}"
                            class="input is-radiusless" placeholder="{{ $label }}" style="width:{{ $width }}px">
                    </div>
                @break

                @case('select')
                    @php
                        [$type, $label, $options, $width] = $field;
                    @endphp
                    <div class="contol select" data-tooltip="{{ $label }}">
                        <select name="{{ $name }}" style="width:{{ $width }}px" class="is-radiusless">
                            <option value="" selected>{{ $label }}</option>
                            @foreach ($options as $ov => $ol)
                                <option value="{{ $ov }}" {{ $ov == $value ? 'selected' : '' }}>{{ $ol }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                @break
            @endswitch
        @endforeach
        <div class="contol">
            <button class="button is-link is-radiusless" id="apply-qf">
                <span class="icon">
                    <i class="fas fa-check"></i>
                </span>
            </button>
        </div>
    </div>
    <script type="module">
        $(document).ready(function() {
            const $context = $('#{{ $id }}')
            const apply = () => {
                let url = '{{ $route }}'
                let isFirst = true;
                $(':input', $context).each(function() {
                    const $this = $(this)
                    if ($this.val()) {
                        const name = $this.attr('name')
                        const val = $this.val()
                        const sep = isFirst ? '?' : '&'
                        url = `${url}${sep}${name}=${val}`
                        isFirst = false
                    }
                })
                window.location.href = url
            }
            $('button#apply-qf', $context).on('click', apply)
            $('input', $context).on('keypress', function(e) {
                if (e.keyCode == 13) {
                    apply()
                }
            })
        });
    </script>
</div>
