<?php

namespace V360\ActionComponents\View\Components;

use Illuminate\View\Component;
use Illuminate\Support\Str;

class Bulkx extends Component
{
  /**
   * Conetxt id
   *
   * @var string
   */
  public string $id;

  /**
   * Route prefix
   * @var string
   */
  public string $routePrefix;

  /**
   * Key value pair for action and lable
   * All actions has to be POST
   * @var array
   */
  public array $actions;

  /**
   * Id of record table
   * @var string
   */
  public string $recordTableId;

  /**
   * Additional path parameters
   *
   * @var string|array
   */
  public $pathParameters;

  /**
   * Create a new component instance.
   *
   * @param string $routePrefix
   * @param array $actions
   * @param string $recordTableId
   * @param string|array $pathParameters
   * @return void
   */
  public function __construct(
    string $routePrefix,
    array $actions,
    string $recordTableId = 'records-table',
    $pathParameters = null
  ) {
    $this->id = Str::uuid()->toString();
    $this->routePrefix = $routePrefix;
    $this->actions = $actions;
    $this->recordTableId = '#' . $recordTableId;
    $this->pathParameters = $pathParameters;
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vaction::components.bulkx');
  }
}
