@if ($isDropdown)
    <div class="dropdown is-hoverable is-right">
        <div class="dropdown-trigger">
            <button class="button is-ghost" aria-haspopup="true" aria-controls="action-menu">
                <span class="icon is-small">
                    <i class="fas fa-ellipsis-v"></i>
                </span>
            </button>
        </div>
        <div class="dropdown-menu" id="action-menu" role="menu">
            <div class="dropdown-content">
                {{ $slot }}
                <hr class="dropdown-divider">
                <div class="dropdown-item">
                    <div class="buttons is-right">
                        @if ($show)
                            <div class="control">
                                <a class="button is-ghost has-text-link" href="{{ route($routePrefix . '.show', $id) }}"
                                    title="Show">
                                    <span class="icon">
                                        <span class="material-symbols-outlined is-size-6">
                                            info_i
                                        </span>
                                    </span>
                                </a>
                            </div>
                        @endif

                        @if ($edit)
                            <div class="control">
                                <a class="button is-ghost has-text-link" href="{{ route($routePrefix . '.edit', $id) }}"
                                    title="Edit">
                                    <span class="icon">
                                        <span class="material-symbols-outlined is-size-6">
                                            edit
                                        </span>
                                    </span>
                                </a>
                            </div>
                        @endif

                        @if ($delete)
                            <div class="control">
                                <form action="{{ route($routePrefix . '.destroy', $id) }}" method="POST"
                                    class="confirm">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="button {{ $deleteClass }} is-inverted is-borderless"
                                        title="{{ $deleteLabel }}">
                                        <span class="icon">
                                            <span class="material-symbols-outlined is-size-6">
                                                {{ $deleteIcon }}
                                            </span>
                                        </span>
                                    </button>
                                </form>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@else
    @if ($show)
        <div class="control">
            <a class="button is-ghost has-text-link" href="{{ route($routePrefix . '.show', $id) }}" title="Show">
                <span class="icon">
                    <span class="material-symbols-outlined is-size-6">
                        info_i
                    </span>
                </span>
            </a>
        </div>
    @endif

    @if ($edit)
        <div class="control">
            <a class="button is-ghost has-text-link" href="{{ route($routePrefix . '.edit', $id) }}" title="Edit">
                <span class="icon">
                    <span class="material-symbols-outlined is-size-6">
                        edit
                    </span>
                </span>
            </a>
        </div>
    @endif

    @if ($delete)
        <div class="control">
            <form action="{{ route($routePrefix . '.destroy', $id) }}" method="POST" class="confirm">
                @csrf
                @method('DELETE')
                <button type="submit" class="button is-ghost has-text-{{ $deleteClass }}"
                    title="{{ $deleteLabel }}">
                    <span class="icon">
                        <span class="material-symbols-outlined is-size-6">
                            {{ $deleteIcon }}
                        </span>
                    </span>
                </button>
            </form>
        </div>
    @endif
@endif
