<div>
    <div class="my-4" id="{{ $panel }}" style="display: none;">
        <x-vshow-container-label icon="filter_alt" label="{{ $panelLabel }}" color="warning">
            <div class="fixed-grid has-2-cols-mobile has-4-cols-tablet has-6-cols-desktop has-8-cols-fullhd">
                <div class="grid">
                    @foreach ($fields as $name => $value)
                        @if (isset($filters[$name]))
                            @php
                                $field = $filters[$name];
                            @endphp
                            @switch($field[0])
                                @case('text')
                                    @php
                                        [$type, $label] = $field;
                                    @endphp
                                    <div class="cell">
                                        <x-vform-text :type=$type :name=$name :value=$value :label=$label
                                            wire:model.lazy="{{ $modelProperty }}.{{ $name }}" />
                                        @isset($fieldHints[$name])
                                            <p class="help is-info">{{ $fieldHints[$name] }}</p>
                                        @endisset
                                    </div>
                                @break

                                @case('number')
                                    @php
                                        [$type, $label] = $field;
                                    @endphp
                                    <div class="cell">
                                        <x-vform-number :type=$type :name=$name :value=$value :label=$label
                                            wire:model.lazy="{{ $modelProperty }}.{{ $name }}" />
                                        @isset($fieldHints[$name])
                                            <p class="help is-info">{{ $fieldHints[$name] }}</p>
                                        @endisset
                                    </div>
                                @break

                                @case('number_range')
                                    @php
                                        [$type, $label] = $field;
                                    @endphp
                                    <div class="cell is-col-span-2">
                                        <div>
                                            <label for="{{ Str::slug($name) }}" class="label">
                                                {{ $label }}
                                            </label>
                                            <div class="field has-addons" id="{{ Str::slug($name) }}">
                                                <p class="control">
                                                    <input class="input" type="number" placeholder="From"
                                                        wire:model.lazy='{{ $modelProperty }}.{{ $name }}.from'>
                                                </p>
                                                <p class="control">
                                                    <a class="button is-static">
                                                        <x-vshow-icon>compare_arrows</x-vshow-icon>
                                                    </a>
                                                </p>
                                                <p class="control is-expanded">
                                                    <input class="input" type="number" placeholder="To"
                                                        wire:model.lazy='{{ $modelProperty }}.{{ $name }}.to'>
                                                </p>
                                            </div>
                                            @isset($fieldHints[$name])
                                                <p class="help is-info">{{ $fieldHints[$name] }}</p>
                                            @endisset
                                        </div>
                                    </div>
                                @break

                                @case('select')
                                @case('select_group')
                                    @php
                                        [$type, $label, $options] = $field;
                                    @endphp
                                    <div class="cell">
                                        <x-vform-select :name=$name :value=$value :label=$label
                                            wire:model.lazy="{{ $modelProperty }}.{{ $name }}" :options=$options />
                                        @isset($fieldHints[$name])
                                            <p class="help is-info">{{ $fieldHints[$name] }}</p>
                                        @endisset
                                    </div>
                                @break

                                @case('date')
                                    @php
                                        [$type, $label] = $field;
                                    @endphp
                                    <div class="cell">
                                        <x-vform-datepicker type='date' :name=$name :value=$value :label=$label
                                            wire:model.lazy="{{ $modelProperty }}.{{ $name }}" />
                                        @isset($fieldHints[$name])
                                            <p class="help is-info">{{ $fieldHints[$name] }}</p>
                                        @endisset
                                    </div>
                                @break

                                @case('switch')
                                    @php
                                        [$type, $label] = $field;
                                    @endphp
                                    <div class="cell">
                                        <div class="is-flex is-align-items-flex-end" style="min-height: 72px;">
                                            <div class="field">
                                                <input id="{{ Str::slug($name) }}" type="checkbox"
                                                    class="switch is-rounded is-info"
                                                    wire:model.live="{{ $modelProperty }}.{{ $name }}" />
                                                <label for="{{ Str::slug($name) }}">
                                                    {{ $label }}
                                                </label>
                                            </div>
                                        </div>
                                        @isset($fieldHints[$name])
                                            <p class="help is-info">{{ $fieldHints[$name] }}</p>
                                        @endisset
                                    </div>
                                @break

                                @case('key_value')
                                    @php
                                        [$type, $label, $options] = $field;
                                    @endphp
                                    <div class="cell is-col-span-2">
                                        <div>
                                            <label for="{{ Str::slug($name) }}" class="label">
                                                {{ $label }}
                                            </label>
                                            <div class="field has-addons" id="{{ Str::slug($name) }}">
                                                <p class="control">
                                                    <span class="select">
                                                        <select
                                                            wire:model.change='{{ $modelProperty }}.{{ $name }}.key'>
                                                            <option value="">Select</option>
                                                            @foreach ($options as $ov => $ol)
                                                                <option value="{{ $ov }}">{{ $ol }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </span>
                                                </p>
                                                <p class="control">
                                                    <a class="button is-static">
                                                        <x-vshow-icon>chevron_right</x-vshow-icon>
                                                    </a>
                                                </p>
                                                <p class="control is-expanded">
                                                    <input class="input" type="text"
                                                        wire:model.lazy='{{ $modelProperty }}.{{ $name }}.value'>
                                                </p>
                                            </div>
                                            @isset($fieldHints[$name])
                                                <p class="help is-info">{{ $fieldHints[$name] }}</p>
                                            @endisset
                                        </div>
                                    </div>
                                @break
                            @endswitch
                        @endif
                    @endforeach
                </div>
            </div>
        </x-vshow-container-label>
        <script type="module">
            $(document).ready(function() {
                const $filterPanel = $('#{{ $panel }}')
                const $filterButton = $('button#toggle-{{ $panel }}')
                $filterButton.on('click', function() {
                    if ($filterPanel.css('display') == 'block') {
                        $filterPanel.fadeOut();
                        $('span.filter-icon', $filterButton).html('{{ $iconOn }}')
                        $filterButton.attr('title', 'Show {{ $panelLabel }} Panel')
                    } else {
                        $filterPanel.fadeIn();
                        $('span.filter-icon', $filterButton).html('{{ $iconOff }}')
                        $filterButton.attr('title', 'Hide {{ $panelLabel }} Panel')
                    }
                })
            });
        </script>
    </div>
</div>
